#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'
require_relative '../../pages/landing_notifications'

describe '[Story# VAR-10212: Merge: Direct Booking of a Video (Mobile Any) appointment - Clinic Display]
          [Story# VAR-10404: Merge: New Appointment - Confirmation Modals & Create Appointment]
          [Story# VAR-10258: Merge: Direct Booking of a Video (Mobile Any) appointment - Email Required]'  do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility
  $date = "02/05/2018"
  $email = "testvideo@gmail.com"
  $typeOfCare = "Primary Care"



  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback = Feedback.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    @modal = Modal.new(@driver)
    TITLE = "Appointments/Requests"
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-10470|TC#VAR-10471: New Appointment/Request Form: Step 1: Type of Care' do

    it 'login and select new appointment request form' do
      @common.loginEndsOnHome(pw_redacted)
      @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notification_detail_new_appt_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notification_detail_new_appt
    end

    it 'should display clinics list for a given type of care at my selected location' do
      #Select Primary Care>Boston>Direct Scheduling
      @new_appointment.selectTypeOfCare("#{$typeOfCare }")
      @new_appointment.selectLocation("523")
      @new_appointment.selectSchedulingMethod("direct")

      #Verify Video Visit Icon exist for "Audiology New" Clinic
      @new_appointment.vv_icon_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@new_appointment.vv_icon_element.visible?). to eq (true)

      #Verify Hospital Vist Icon exist for "PRIMARY CARE 2 (HFE)" Clinic
      @new_appointment.hospital_icon_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@new_appointment.hospital_icon_element.visible?).to eq (true)
    end

  end

  context 'AC#VAR-10684|TC#VAR-10685: Merge: Direct Booking of a Video (Mobile Any) appointment - Email Required' do

    it 'select video visit appointment and fill the form' do
      @new_appointment.selectClinic("487")
      @new_appointment.provideReasonForAppointment("test")
      @new_appointment.selectPreferedDate("#{$date}", "10:30")
      @new_appointment.enterEmail("#{$email}")
    end

    it 'should display instructional text after the last line of clinic information' do
      @new_appointment.instructional_text_video_appt_clinic_element.wait_until_present(TIME_OUT_LIMIT)
      expected_content =[\
                        "To support this Video Appointment, please ensure you have a current email address included in your Email Preferences shown below."
      ]
      actual_content = @new_appointment.instructional_text_video_appt_clinic_element.text.split("\n")

      compareContents(actual_content,  expected_content)
    end

    it 'should display instruction text after the the section header "Notification Settings"' do
      @new_appointment.instructional_text_video_appt_noti_settings_element.wait_until_present(TIME_OUT_LIMIT)
      expected_content =[\
                        "Video Visits require that you accept Appointment and Request notifications, and that you provide an email address so that we may send you the video connection information.",
                        "Please confirm your notification contact information before scheduling this appointment."
      ]
      actual_content = @new_appointment.instructional_text_video_appt_noti_settings_element.text.split("\n")

      compareContents(actual_content,  expected_content)
    end

  end

  context 'AC#VAR-10650|TC#VAR-10651: Merge: New Appointment - Confirmation Modals & Create Appointment' do

    it 'should display Confirmation Modal for video-visit appointment' do
      #Verify Video Visit Confirmation Modal Content
      @new_appointment.confirm_appointment_element.wait_until_present(TIME_OUT_LIMIT)
      @new_appointment.confirm_appointment_element.click
      expect(@modal.modalTitle).to eq "Confirm Appointment"
      expected_content =[\
                        "You are scheduling a Video Appointment for:",
                        "#{$date} @ 1030 UTC",
                        "Type of Care: #{$typeOfCare }",
                        "Your video appointment link will be sent to:",
                        "#{$email}",
                        "For a Video Appointment, please remember:",
                        "You will need to join the appointment from a computer, tablet, or smartphone with internet access",
                        "The device you join with will need to have a camera and microphone",
                        "The email address you have provided will be used to send a link that will allow you to join the appointment and receive appointment reminders"
      ]
      actual_content = @modal.content.split("\n")

      compareContents(actual_content,  expected_content)

      @modal.confirm_continue_element.exist?
      @modal.confirm_return_element.exist?

      @modal.confirm_return
    end

    it 'select regular appointment and fill the form' do
      @new_appointment.selectClinic("32")
      @new_appointment.provideReasonForAppointment("test")
      @new_appointment.selectPreferedDate("#{$date}", "10:30")
      @new_appointment.enterEmail("#{$email}")
    end

    it 'should display Confirmation Modal for regular appointment' do
      #Verify Regular Confirmation Modal Content
      @new_appointment.confirm_appointment_element.wait_until_present(TIME_OUT_LIMIT)
      @new_appointment.confirm_appointment_element.click
      expect(@modal.modalTitle).to eq "Confirm Appointment"
      expected_content =[\
                        "You are scheduling an In-Person Appointment for:",
                        "#{$date} @ 1030 UTC",
                        "Type of Care: #{$typeOfCare }",
                        "Boston Facility Friendly Text",
                        "PRIMARY CARE",
                        "JP PRIMARY CARE DR. CREAMER"
      ]
      actual_content = @modal.content.split("\n")

      compareContents(actual_content,  expected_content)

      @modal.confirm_continue_element.exist?
      @modal.confirm_return_element.exist?
    end

  end

end